<?php
/**
 * File 2017_10_16_141108_update_feedback_form_table.php
 *
 * @package    Database\Migrations\v2_3_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.3.0
 */
namespace Database\Migrations\v2_3_0\Ticket;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateFeedbackFormTable
 *
 * @package    Database\Migrations\v2_3_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.3.0
 */
class UpdateFeedbackFormTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('feedback_form', function (Blueprint $table) {
            $table->dropForeign([ 'email_template_id' ]);
        });

        Schema::table('feedback_form', function (Blueprint $table) {
            $table->integer('email_template_id')->unsigned()->nullable()->change();
            $table->foreign('email_template_id')->references('id')->on('email_template')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('feedback_form', function (Blueprint $table) {
            $table->dropForeign([ 'email_template_id' ]);
        });

        Schema::table('feedback_form', function (Blueprint $table) {
            $table->integer('email_template_id')->unsigned()->change();
            $table->foreign('email_template_id')->references('id')->on('email_template')->onDelete('cascade');
        });
    }
}
