<?php
/**
 * File 2017_10_16_143309_update_ticket_followup_table.php
 *
 * @package    Database\Migrations\v2_3_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.3.0
 */
namespace Database\Migrations\v2_3_0\Ticket;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateTicketFollowupTable
 *
 * @package    Database\Migrations\v2_3_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.3.0
 */
class UpdateTicketFollowupTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ticket_followup', function (Blueprint $table) {
            $table->dropForeign([ 'status_id' ]);
        });

        Schema::table('ticket_followup', function (Blueprint $table) {
            $table->integer('status_id')->unsigned()->nullable()->change();
            $table->foreign('status_id')->references('id')->on('ticket_status')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ticket_followup', function (Blueprint $table) {
            $table->dropForeign([ 'status_id' ]);
        });

        Schema::table('ticket_followup', function (Blueprint $table) {
            $table->integer('status_id')->unsigned()->change();
            $table->foreign('status_id')->references('id')->on('ticket_status')->onDelete('cascade');
        });
    }
}
