<?php
/**
 * File 2017_12_09_143000_update_ticket_message_table.php
 *
 * @package    Database\Migrations\v2_3_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.3.0
 */
namespace Database\Migrations\v2_3_0\Ticket;

use DB;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateTicketMessageTable
 *
 * @package    Database\Migrations\v2_3_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.3.0
 */
class UpdateTicketMessageTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ticket_message', function (Blueprint $table) {
            $table->text('extra')->nullable()->after('social_id');
        });

        DB::unprepared("alter table `ticket_message` add index `ticket_message_social_id_index`(`social_id` (191));");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Remove column
        Schema::table('ticket_message', function (Blueprint $table) {
            $table->dropColumn('extra');
            $table->dropIndex(['social_id']);
        });
    }
}
