<?php
/**
 * File 2017_10_02_083258_update_user_customfield_translation_table.php
 *
 * @package    Database\Migrations\v2_3_0\User
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.3.0
 */
namespace Database\Migrations\v2_3_0\User;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateUserCustomfieldTranslationTable
 *
 * @package    Database\Migrations\v2_3_0\User
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.3.0
 */
class UpdateUserCustomfieldTranslationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('user_customfield_translation', function (Blueprint $table) {
            $table->text('regex_error_message')->nullable()->after('description');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('user_customfield_translation', function (Blueprint $table) {
            $table->dropColumn('regex_error_message');
        });
    }
}
