<?php
/**
 * File 2018_02_06_180520_update_brand_table.php
 *
 * @package    Database\Migrations\v2_3_1\Core
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.3.1
 */
namespace Database\Migrations\v2_3_1\Core;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateBrandTable
 *
 * @package    Database\Migrations\v2_3_1\Core
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.3.1
 */
class UpdateBrandTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('brand', function (Blueprint $table) {
            $table->tinyInteger('enable_ssl')->nullable()->after('system_url');
            $table->string('brand_colour', 7)->nullable()->after('system_url');
            $table->string('frontend_logo_url')->nullable()->after('frontend_logo');
            $table->string('favicon')->nullable()->after('frontend_logo_url');
            $table->string('operator_icon')->nullable()->after('frontend_template');
            $table->string('operator_template')->nullable()->after('operator_icon');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('brand', function (Blueprint $table) {
            $table->dropColumn([
                'enable_ssl', 'brand_colour', 'frontend_logo_url', 'favicon', 'operator_icon', 'operator_template'
            ]);
        });
    }
}
