<?php
/**
 * File 2018_04_027_131800_create_export_table.php
 *
 * @package    Database\Migrations\v2_3_1\Core
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.3.1
 */
namespace Database\Migrations\v2_3_1\Core;

use DB;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class CreateExportTable
 *
 * @package    Database\Migrations\v2_3_1\Core
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.3.1
 */
class CreateExportTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Create table.
        Schema::create('export', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->charset = 'utf8';
            $table->collation = 'utf8_unicode_ci';

            $table->increments('id')->unsigned();

            $table->string('upload_hash');
            $table->foreign('upload_hash')->references('hash')->on('upload')->onDelete('cascade');

            $table->integer('user_id')->unsigned()->nullable();
            $table->foreign('user_id')->references('id')->on('user')->onDelete('cascade');

            $table->integer('created_at');
            $table->integer('updated_at')->default(0);
        });

        // We need to do this separately or else you can't add upload hash foreign key which is utf8 not utf8mb4.
        DB::unprepared("ALTER TABLE `export` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Drop table.
        Schema::drop('export');
    }
}
