<?php
/**
 * File 2018_05_07_182236_create_email_log_user_membership_table.php
 *
 * @package    Database\Migrations\v2_3_1\Core
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.3.1
 */
namespace Database\Migrations\v2_3_1\Core;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class CreateEmailLogUserMembershipTable
 *
 * @package    Database\Migrations\v2_3_1\Core
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.3.1
 */
class CreateEmailLogUserMembershipTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('email_log_user_membership', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('user')->onDelete('cascade');

            $table->integer('email_log_id')->unsigned();
            $table->foreign('email_log_id')->references('id')->on('email_log')->onDelete('cascade');
            
            $table->tinyInteger('type')->unsigned()->default(1);
            
            $table->unique([ 'user_id', 'email_log_id' ]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('email_log_user_membership');
    }
}
