<?php
/**
 * File 2018_01_13_141657_update_article_table.php
 *
 * @package    Database\Migrations\v2_3_1\Selfservice
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.3.1
 */
namespace Database\Migrations\v2_3_1\Selfservice;

use DB;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateArticleTable
 *
 * @package    Database\Migrations\v2_3_1\Selfservice
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.3.1
 */
class UpdateArticleTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('article', function (Blueprint $table) {
            $table->integer('published_at')->unsigned()->nullable()->after('published');
            $table->boolean('pinned')->default(0)->after('protected');

            $table->index('pinned');
        });

        DB::update('UPDATE `article` SET `published_at` = `created_at` WHERE `published` = 1;');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('article', function (Blueprint $table) {
            $table->dropIndex([ 'pinned' ]);

            $table->dropColumn('published_at');
            $table->dropColumn('pinned');
        });
    }
}
