<?php
/**
 * File 2018_01_19_134400_update_article_type_table.php
 *
 * @package    Database\Migrations\v2_3_1\Selfservice
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.3.1
 */
namespace Database\Migrations\v2_3_1\Selfservice;

use App\Modules\Selfservice\Models\Type;
use DB;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateArticleTypeTable
 *
 * @package    Database\Migrations\v2_3_1\Selfservice
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.3.1
 */
class UpdateArticleTypeTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('article_type', function (Blueprint $table) {
            // Make columns NULLABLE.
            $table->text('slug')->nullable()->change();
            $table->binary('icon')->nullable()->change();
            
            // Add new columns
            $table->tinyInteger('internal')->default(0)->after('enabled');
            $table->tinyInteger('content')->default(0)->after('internal');
            $table->tinyInteger('article_ordering')->nullable()->after('icon');
            $table->string('external_link', 255)->nullable()->after('show_on_dashboard');
        });

        // Set default article ordering for types
        DB::table('article_type')->where('view', Type::VIEW_HIERARCHICAL)->update([ 'article_ordering' => Type::ORDER_POPULAR ]);
        DB::table('article_type')->where('view', Type::VIEW_LIST)->update([ 'article_ordering' => Type::ORDER_RECENT ]);

        // Update existing columns
        // Need to do in raw statements as not currently possible to update tinyInteger columns.
        DB::statement("ALTER TABLE `article_type` CHANGE `view` `view` TINYINT(4) NULL DEFAULT NULL COMMENT '0 - Hierarchical, 1 - List';");
        DB::statement("ALTER TABLE `article_type` CHANGE `show_on_dashboard` `show_on_dashboard` TINYINT(4) NULL DEFAULT NULL;");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('article_type', function (Blueprint $table) {
            // Revert updates to existing columns
            $table->binary('icon')->nullable(false)->change();
            $table->text('slug')->nullable(false)->change();

            // Remove new columns
            $table->dropColumn('internal');
            $table->dropColumn('content');
            $table->dropColumn('article_ordering');
            $table->dropColumn('external_link');
        });

        // Revert updates to existing columns
        DB::statement('ALTER TABLE article_type CHANGE `view` `view` TINYINT(4) NOT NULL DEFAULT 0;');
        DB::statement('ALTER TABLE article_type CHANGE `show_on_dashboard` `show_on_dashboard` TINYINT(4) NOT NULL DEFAULT 1;');
    }
}
