<?php
/**
 * File 2018_01_24_130400_update_article_type_translation_table.php
 *
 * @package    Database\Migrations\v2_3_1\Selfservice
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.3.1
 */
namespace Database\Migrations\v2_3_1\Selfservice;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateArticleTypeTranslationTable
 *
 * @package    Database\Migrations\v2_3_1\Selfservice
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.3.1
 */
class UpdateArticleTypeTranslationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('article_type_translation', function (Blueprint $table) {
            $table->text('slug')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('article_type_translation', function (Blueprint $table) {
            $table->text('slug')->nullable(false)->change();
        });
    }
}
