<?php
/**
 * File 2018_03_06_150805_update_ticket_macro_table.php
 *
 * @package    Database\Migrations\v2_3_1\Ticket
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.3.1
 */
namespace Database\Migrations\v2_3_1\Ticket;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateTicketMacroTable
 *
 * @package    Database\Migrations\v2_3_1\Ticket
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.3.1
 */
class UpdateTicketMacroTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ticket_macro', function (Blueprint $table) {
            $table->integer('user_id')->unsigned()->nullable()->after('run_type');
            $table->foreign('user_id')->references('id')->on('user')->onDelete('cascade');

            $table->tinyInteger('all_groups')->default(1)->after('user_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ticket_macro', function (Blueprint $table) {
            $table->dropForeign([ 'user_id' ]);
            $table->dropColumn([ 'user_id', 'all_groups' ]);
        });
    }
}
