<?php
/**
 * File 2018_03_01_154700_create_user_social_provider_table.php
 *
 * @package    Database\Migrations\v2_3_1\User
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.3.1
 */
namespace Database\Migrations\v2_3_1\User;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class CreateUserSocialProviderTable
 *
 * @package    Database\Migrations\v2_3_1\User
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.3.1
 */
class CreateUserSocialProviderTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Create table.
        Schema::create('user_social_provider', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->increments('id')->unsigned();

            $table->string('name', 45);

            $table->integer('brand_id')->unsigned()->nullable();
            $table->foreign('brand_id')->references('id')->on('brand')->onDelete('cascade');

            $table->tinyInteger('enabled')->default(1);

            $table->string('client_id', 255);
            $table->string('client_secret', 255);

            $table->integer('created_at');
            $table->integer('updated_at')->default(0);

            $table->unique([ 'name', 'brand_id' ]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Drop table.
        Schema::drop('user_social_provider');
    }
}
