<?php
/**
 * File 2018_07_09_141018_create_email_log_raw_table.php
 *
 * @package    Database\Migrations\v2_4_0\Core
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.4.0
 */
namespace Database\Migrations\v2_4_0\Core;

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class CreateEmailLogRawTable
 *
 * @package    Database\Migrations\v2_4_0\Core
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.4.0
 */
class CreateEmailLogRawTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('email_log_raw', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->integer('log_id')->unsigned();
            $table->foreign('log_id')->references('id')->on('email_log')->onDelete('cascade');

            $table->integer('upload_id')->unsigned();
            $table->foreign('upload_id')->references('id')->on('upload')->onDelete('cascade');

            $table->unique([ 'log_id', 'upload_id' ]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('email_log_raw');
    }
}
