<?php
/**
 * File 2018_08_15_134600_update_operator_private_message_table.php
 *
 * @package    Database\Migrations\v2_4_0\Core
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.4.0
 */
namespace Database\Migrations\v2_4_0\Core;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateOperatorPrivateMessageTable
 *
 * @package    Database\Migrations\v2_4_0\Core
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.4.0
 */
class UpdateOperatorPrivateMessageTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('operator_private_message', function (Blueprint $table) {
            $table->longText('purified_message')->after('message');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('operator_private_message', function (Blueprint $table) {
            $table->dropColumn('purified_message');
        });
    }
}
