<?php
/**
 * File 2018_08_12_112200_update_article_table.php
 *
 * @package    Database\Migrations\v2_4_0\Selfservice
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.4.0
 */
namespace Database\Migrations\v2_4_0\Selfservice;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateArticleTable
 *
 * @package    Database\Migrations\v2_4_0\Selfservice
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.4.0
 */
class UpdateArticleTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('article', function (Blueprint $table) {
            $table->string('excerpt', 255)->change();
            $table->longText('purified_text')->after('text');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('article', function (Blueprint $table) {
            $table->longText('excerpt')->change();
            $table->dropColumn('purified_text');
        });
    }
}
