<?php
/**
 * File 2018_05_29_090025_update_department_email_table.php
 *
 * @package    Database\Migrations\v2_4_0\Ticket
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.4.0
 */
namespace Database\Migrations\v2_4_0\Ticket;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateDepartmentEmailTable
 *
 * @package    Database\Migrations\v2_4_0\Ticket
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.4.0
 */
class UpdateDepartmentEmailTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('department_email', function (Blueprint $table) {
            $table->string('username', 255)->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('department_email', function (Blueprint $table) {
            $table->string('username', 45)->nullable()->change();
        });
    }
}
