<?php
/**
 * File 20182018_06_18_165200_update_ticket_escalation_rule_table.php
 *
 * @package    Database\Migrations\v2_4_0\Ticket
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.4.0
 */
namespace Database\Migrations\v2_4_0\Ticket;

use App\Modules\Core\Controllers\Database\Migration\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateTicketEscalationRuleTable
 *
 * @package    Database\Migrations\v2_4_0\Ticket
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.4.0
 */
class UpdateTicketEscalationRuleTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $this->deleteDuplicates('ticket_escalation_rule', 'ticket_id', 'rule_id');

        Schema::table('ticket_escalation_rule', function (Blueprint $table) {
            $table->unique([ 'ticket_id', 'rule_id' ]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Drop foreign keys
        Schema::table('ticket_escalation_rule', function (Blueprint $table) {
            $table->dropForeign([ 'ticket_id' ]);
            $table->dropForeign([ 'rule_id' ]);
        });

        Schema::table('ticket_escalation_rule', function (Blueprint $table) {
            $table->dropUnique([ 'ticket_id', 'rule_id' ]);
        });
    }
}
