<?php
/**
 * File 2018_07_09_121500_create_ticket_macro_event_table.php
 *
 * @package    Database\Migrations\v2_4_0\Ticket
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.4.0
 */
namespace Database\Migrations\v2_4_0\Ticket;

use App\Modules\Ticket\Events\TicketEvent;
use App\Modules\Ticket\Models\Macro;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class CreateTicketMacroEventTable
 *
 * @package    Database\Migrations\v2_4_0\Ticket
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.4.0
 */
class CreateTicketMacroEventTable extends Migration
{
    /**
     * Old macro run type value
     */
    const AUTO_ALL = 2;

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ticket_macro_event', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->integer('macro_id')->unsigned();
            $table->foreign('macro_id')->references('id')->on('ticket_macro')->onDelete('cascade');

            $table->smallInteger('event_id')->default(0);

            $table->unique([ 'macro_id', 'event_id' ]);
        });

        // Create event link with new ticket hook for all non-manual macros.
        foreach (Macro::whereIn('run_type', [ Macro::TYPE_HOOK, Macro::TYPE_AUTOMATIC ])->get([ 'id' ]) as $macro) {
            $macro->events()->create([ 'event_id' => TicketEvent::NEW_TICKET ]);
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('ticket_macro_event');
    }
}
