<?php
/**
 * File 2018_07_09_174000_update_ticket_macro_run_table.php
 *
 * @package    Database\Migrations\v2_4_0\Ticket
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.4.0
 */
namespace Database\Migrations\v2_4_0\Ticket;

use App\Modules\Core\Controllers\Database\Migration\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateTicketMacroRunTable
 *
 * @package    Database\Migrations\v2_4_0\Ticket
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.4.0
 */
class UpdateTicketMacroRunTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $this->deleteDuplicates('ticket_macro_run', 'ticket_id', 'macro_id');
        
        Schema::table('ticket_macro_run', function (Blueprint $table) {
            $table->unique([ 'ticket_id', 'macro_id' ]);
            $table->integer('times')->default(1)->after('macro_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Drop foreign keys
        Schema::table('ticket_macro_run', function (Blueprint $table) {
            $table->dropForeign([ 'ticket_id' ]);
            $table->dropForeign([ 'macro_id' ]);
        });

        Schema::table('ticket_macro_run', function (Blueprint $table) {
            $table->dropUnique([ 'ticket_id', 'macro_id' ]);
            $table->dropColumn('times');
        });
    }
}
