<?php
/**
 * File 2018_07_23_173600_update_canned_response_table.php
 *
 * @package    Database\Migrations\v2_4_0\Ticket
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.4.0
 */
namespace Database\Migrations\v2_4_0\Ticket;

use App\Modules\Ticket\Models\CannedResponse;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateCannedResponseTable
 *
 * @package    Database\Migrations\v2_4_0\Ticket
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.4.0
 */
class UpdateCannedResponseTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('canned_response', function (Blueprint $table) {
            $table->longText('purified_text')->after('text');
            $table->string('hash', 45)->after('all_groups');
        });

        // Generate hash for each canned response
        foreach (CannedResponse::all() as $response) {
            $response->hash = CannedResponse::generateHash();
            $response->save();
        }

        Schema::table('canned_response', function (Blueprint $table) {
            $table->unique('hash');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('canned_response', function (Blueprint $table) {
            $table->dropColumn([ 'purified_text', 'hash' ]);
        });
    }
}
