<?php
/**
 * File 2018_09_10_200000_update_canned_response_translation_table.php
 *
 * @package    Database\Migrations\v2_4_0\Ticket
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.4.0
 */
namespace Database\Migrations\v2_4_0\Ticket;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateCannedResponseTranslationTable
 *
 * @package    Database\Migrations\v2_4_0\Ticket
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.4.0
 */
class UpdateCannedResponseTranslationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('canned_response_translation', function (Blueprint $table) {
            $table->longText('purified_text')->after('text');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('canned_response_translation', function (Blueprint $table) {
            $table->dropColumn('purified_text');
        });
    }
}
