<?php
/**
 * File 2018_10_15_181840_update_article_table.php
 *
 * @package    Database\Migrations\v2_4_1\Selfservice
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.4.0
 */
namespace Database\Migrations\v2_4_1\Selfservice;

use DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class UpdateArticleTable
 *
 * @package    Database\Migrations\v2_4_1\Selfservice
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.4.1
 */
class UpdateArticleTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $doctrineTable = Schema::getConnection()
            ->getDoctrineSchemaManager()
            ->listTableDetails('article');

        // Check if the table already has index.
        if (! $doctrineTable->hasIndex('title')) {
            // Add full text indexes
            DB::statement('ALTER TABLE article ADD FULLTEXT(title, text)');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('article', function (Blueprint $table) {
            $table->dropIndex('title');
        });
    }
}
