<?php
/**
 * File 2018_10_15_181843_update_article_translation_table.php
 *
 * @package    Database\Migrations\v2_4_0\Selfservice
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.4.0
 */
namespace Database\Migrations\v2_4_1\Selfservice;

use DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class UpdateArticleTranslationTable
 *
 * @package    Database\Migrations\v2_4_1\Selfservice
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.4.1
 */
class UpdateArticleTranslationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('article_translation', function (Blueprint $table) {
            $table->longText('purified_text')->after('text');
        });

        $doctrineTable = Schema::getConnection()
            ->getDoctrineSchemaManager()
            ->listTableDetails('article_translation');

        // Check if the table already has index.
        if (! $doctrineTable->hasIndex('title')) {
            // Add full text indexes
            DB::statement('ALTER TABLE article_translation ADD FULLTEXT(title, text)');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('article_translation', function (Blueprint $table) {
            $table->dropColumn('purified_text');
            $table->dropIndex('title');
        });
    }
}
