<?php
/**
 * File 2018_10_30_141200_update_ticket_macro_run_table.php
 *
 * @package    Database\Migrations\v2_4_1\Ticket
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.4.1
 */
namespace Database\Migrations\v2_4_1\Ticket;

use App\Modules\Core\Controllers\Database\Migration\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateTicketMacroRunTable
 *
 * @package    Database\Migrations\v2_4_1\Ticket
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.4.1
 */
class UpdateTicketMacroRunTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (Schema::hasColumn('ticket_macro_run', 'id')) {
            Schema::table('ticket_macro_run', function (Blueprint $table) {
                $table->dropColumn('id');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ticket_macro_run', function (Blueprint $table) {
            $table->increments('id')->unsigned()->first();
        });
    }
}
