<?php
/**
 * File 2018_10_30_165100_update_ticket_escalation_rule_table.php
 *
 * @package    Database\Migrations\v2_4_1\Ticket
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.4.1
 */
namespace Database\Migrations\v2_4_1\Ticket;

use App\Modules\Core\Controllers\Database\Migration\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateTicketEscalationRuleTable
 *
 * @package    Database\Migrations\v2_4_1\Ticket
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.4.1
 */
class UpdateTicketEscalationRuleTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (Schema::hasColumn('ticket_escalation_rule', 'id')) {
            Schema::table('ticket_escalation_rule', function (Blueprint $table) {
                $table->dropColumn('id');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ticket_escalation_rule', function (Blueprint $table) {
            $table->increments('id')->unsigned()->first();
        });
    }
}
