<?php
/**
 * File 2018_11_10_193905_update_ticket_message_table.php
 *
 * @package    Database\Migrations\v2_4_1\Ticket
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.4.1
 */
namespace Database\Migrations\v2_4_1\Ticket;

use DB;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateTicketMessageTable
 *
 * @package    Database\Migrations\v2_4_1\Ticket
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.4.1
 */
class UpdateTicketMessageTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $doctrineTable = Schema::getConnection()
            ->getDoctrineSchemaManager()
            ->listTableDetails('ticket_message');

        // Check if the table already has index. This is important because this file is reused and the index
        // may already exist.
        if (! $doctrineTable->hasIndex('text')) {
            // Add full text index
            DB::statement('ALTER TABLE ticket_message ADD FULLTEXT(text)');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ticket_message', function (Blueprint $table) {
            $table->dropIndex('text');
        });
    }
}
