<?php
/**
 * File 2018_11_01_123452_update_user_organisation_customfield_value_table.php
 *
 * @package    Database\Migrations\v2_4_1\User
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.4.1
 */
namespace Database\Migrations\v2_4_1\User;

use DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class UpdateUserOrganisationCustomfieldValue
 *
 * @package    Database\Migrations\v2_4_1\User
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.4.1
 */
class UpdateUserOrganisationCustomfieldValue extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('user_organisation_customfield_value', function (Blueprint $table) {
            $table->tinyInteger('encrypted')->default(0)->after('value');
        });

        $query = <<<EOT
UPDATE `user_organisation_customfield_value` `v`
INNER JOIN `user_organisation_customfield` `c` ON `c`.`id` = `v`.field_id
SET `v`.`encrypted` = 1
WHERE `c`.encrypted = 1;
EOT;

        DB::unprepared($query);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('user_organisation_customfield_value', function (Blueprint $table) {
            $table->dropColumn('encrypted');
        });
    }
}
