<?php
/**
 * File 2019_03_19_161400_update_widget_table.php
 *
 * @package    Database\Migrations\v2_5_0\Core
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.5.0
 */
namespace Database\Migrations\v2_5_0\Core;

use DB;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateWidgetTable
 *
 * @package    Database\Migrations\v2_5_0\Core
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.5.0
 */
class UpdateWidgetTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('operator_widget', function (Blueprint $table) {
            $table->dropForeign([ 'widget_id' ]);

        });
        Schema::table('widget_role', function (Blueprint $table) {
            $table->dropForeign([ 'widget_id' ]);
        });

        $newId = 1;
        foreach (DB::table('widget')->get() as $widget) {
            // Update related tables
            DB::table('operator_widget')->where('widget_id', $widget->id)->update([ 'widget_id' => $newId ]);
            DB::table('widget_role')->where('widget_id', $widget->id)->update([ 'widget_id' => $newId ]);

            // Update model
            DB::table('widget')->where('id', $widget->id)->update([
                'name' => $widget->id,
                'id'   => $newId++
            ]);
        }

        Schema::table('widget', function (Blueprint $table) {
            $table->increments('id')->charset(null)->change();
            $table->tinyInteger('enabled')->default(0)->after('name');
            $table->string('version')->nullable()->after('enabled');
            $table->tinyInteger('upgrade_available')->default(0)->after('enabled');
        });

        // If we're upgrading from a previous version then all widgets should be enabled to replicate old functionality.
        // In new installations, no widgets will exist in the table yet so this won't do anything. Widgets are activated
        // when creating the operator account using $driver->activate($widget);
        DB::table('widget')->update(['enabled' => 1]);

        Schema::table('operator_widget', function (Blueprint $table) {
            $table->integer('widget_id')->unsigned()->charset(null)->change();
            $table->foreign('widget_id')->references('id')->on('widget')->onDelete('cascade');
        });
        Schema::table('widget_role', function (Blueprint $table) {
            $table->integer('widget_id')->unsigned()->charset(null)->change();
            $table->foreign('widget_id')->references('id')->on('widget')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('operator_widget', function (Blueprint $table) {
            $table->dropForeign([ 'widget_id' ]);

        });
        Schema::table('widget_role', function (Blueprint $table) {
            $table->dropForeign([ 'widget_id' ]);
        });

        $widgets = DB::table('widget')->get();

        // Update related tables
        foreach ($widgets as $widget) {
            DB::table('operator_widget')->where('widget_id', $widget->id)->update([ 'widget_id' => $widget->name ]);
            DB::table('widget_role')->where('widget_id', $widget->id)->update([ 'widget_id' => $widget->name ]);
        }

        Schema::table('widget', function (Blueprint $table) {
            $table->string('id')->charset(null)->change();
            $table->dropColumn(['enabled', 'version', 'upgrade_available']);
        });

        foreach ($widgets as $widget) {
            DB::table('widget')->where('id', $widget->id)->update(['id' => $widget->name]);
        }

        Schema::table('operator_widget', function (Blueprint $table) {
            $table->string('widget_id')->charset(null)->change();
            $table->foreign('widget_id')->references('id')->on('widget')->onDelete('cascade');
        });
        Schema::table('widget_role', function (Blueprint $table) {
            $table->string('widget_id')->charset(null)->change();
            $table->foreign('widget_id')->references('id')->on('widget')->onDelete('cascade');
        });
    }
}
