<?php
/**
 * File 2019_01_22_204100_update_ticket_escalation_rule_table.php
 *
 * @package    Database\Migrations\v2_5_0\Ticket
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.5.0
 */
namespace Database\Migrations\v2_5_0\Ticket;

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class UpdateTicketEscalationRuleTable
 *
 * @package    Database\Migrations\v2_5_0\Ticket
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.5.0
 */
class UpdateTicketEscalationRuleTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ticket_escalation_rule', function (Blueprint $table) {
            $table->index('run_time');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ticket_escalation_rule', function (Blueprint $table) {
            $table->dropIndex([ 'run_time' ]);
        });
    }
}
