<?php
/**
 * File 2019_03_21_128200_update_ticket_channel_table.php
 *
 * @package    Database\Migrations\v2_5_0\Ticket
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.5.0
 */
namespace Database\Migrations\v2_5_0\Ticket;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateTicketChannelTable
 *
 * @package    Database\Migrations\v2_5_0\Ticket
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.5.0
 */
class UpdateTicketChannelTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ticket_channel', function (Blueprint $table) {
            $table->dropColumn('class');
            $table->string('version')->nullable()->after('enabled');
            $table->tinyInteger('upgrade_available')->default(0)->after('enabled');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ticket_channel', function (Blueprint $table) {
            $table->string('class')->after('enabled');
            $table->dropColumn(['version', 'upgrade_available']);
        });
    }
}
