<?php
/**
 * File 2018_11_16_153200_create_user_organisation_domain_table.php
 *
 * @package    Database\Migrations\v2_5_0\User
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.5.0
 */
namespace Database\Migrations\v2_5_0\User;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class CreateUserOrganisationDomainTable
 *
 * @package    Database\Migrations\v2_5_0\User
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.5.0
 */
class CreateUserOrganisationDomainTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Create table.
        Schema::create('user_organisation_domain', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->integer('organisation_id')->unsigned();
            $table->foreign('organisation_id')->references('id')->on('user_organisation')->onDelete('cascade');

            $table->string('domain', 191);

            $table->unique([ 'organisation_id', 'domain' ], 'user_organisation_domain_unique');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Drop table.
        Schema::drop('user_organisation_domain');
    }
}
