<?php
/**
 * File 2019_01_14_191044_update_user_table.php
 *
 * @package    Database\Migrations\v2_5_0\User
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.5.0
 */
namespace Database\Migrations\v2_5_0\User;

use App\Modules\User\Models\User;
use DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class UpdateUserTable
 *
 * @package    Database\Migrations\v2_5_0\User
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.5.0
 */
class UpdateUserTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('user', function (Blueprint $table) {
            // By default all new accounts are active (can login).
            // We check whether they've confirmed their email address at login.
            $table->tinyInteger('active')->default(1)->after('confirmed');

            // Index created_at column
            $table->index('created_at');
        });

        // Copy 'confirmed' value to 'active' for operators only. Users are fine with the default '1'.
        DB::table('user')->where('role', User::ROLE_OPERATOR)->update([ 'active' => DB::raw('confirmed') ]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('user', function (Blueprint $table) {
            $table->dropColumn('active');
            $table->dropIndex([ 'created_at' ]);
        });
    }
}
