<?php
/**
 * File 2019_10_10_213200_update_spam_rule_table.php
 *
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.6.0
 */
namespace Database\Migrations\v2_6_0\Core;

use DB;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateSpamRuleTable
 *
 * @package    Database\Migrations\v2_6_0\Core
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.6.0
 */
class UpdateSpamRuleTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('spam_rule', function (Blueprint $table) {
            $table->smallInteger('is_regex')->default(0)->after('type');
        });

        // Enable is_regex for all existing rules.
        DB::table('spam_rule')->update(['is_regex' => 1]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('spam_rule', function (Blueprint $table) {
            $table->dropColumn([ 'is_regex' ]);
        });
    }
}
