<?php
/**
 * File 2019_05_24_213200_update_schedule_holiday_table.php
 *
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.6.0
 */
namespace Database\Migrations\v2_6_0\Ticket;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateScheduleHolidayTable
 *
 * @package    Database\Migrations\v2_6_0\Ticket
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.6.0
 */
class UpdateScheduleHolidayTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('schedule_holiday', function (Blueprint $table) {
            $table->smallInteger('number_of_days')->default(1)->after('weekday');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('schedule_holiday', function (Blueprint $table) {
            $table->dropColumn([ 'number_of_days' ]);
        });
    }
}
