<?php
/**
 * File 2019_10_14_164700_update_registration_confirmation_table.php
 *
 * @package    Database\Migrations\v2_6_0\User
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.6.0
 */
namespace Database\Migrations\v2_6_0\User;

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class UpdateRegistrationConfirmationTable
 *
 * @package    Database\Migrations\v2_6_0\User
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.6.0
 */
class UpdateRegistrationConfirmationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('registration_confirmation', function (Blueprint $table) {
            $table->string('new_email')->nullable()->after('token');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('registration_confirmation', function (Blueprint $table) {
            $table->dropColumn('new_email');
        });
    }
}
