<?php
/**
 * File 2019_11_08_182500_update_brand_table.php
 *
 * @package    Database\Migrations\v3_0_0\Core
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 3.0.0
 */
namespace Database\Migrations\v3_0_0\Core;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateBrandTable
 *
 * @package    Database\Migrations\v3_0_0\Core
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 3.0.0
 */
class UpdateBrandTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('brand', function (Blueprint $table) {
            $table->string('frontend_logo_dark_mode')->nullable()->after('frontend_logo');
            $table->tinyInteger('frontend_template_mode')->default(0)->after('frontend_template');
            $table->tinyInteger('operator_template_mode')->default(0)->after('operator_template');

            $table->renameColumn('frontend_logo_url', 'website_url');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('brand', function (Blueprint $table) {
            $table->dropColumn(['frontend_logo_dark_mode', 'frontend_template_mode', 'operator_template_mode']);

            $table->renameColumn('website_url', 'frontend_logo_url');
        });
    }
}
