<?php
/**
 * File 2020_03_06_151049_update_permission_table.php
 *
 * @package    Database\Migrations\v3_0_0
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 3.0.0
 */
namespace Database\Migrations\v3_0_0;

use DB;
use Illuminate\Database\Migrations\Migration;

/**
 * Class UpdatePermissionTable
 *
 * @package    Database\Migrations\v3_0_0
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      Class available since Release 3.0.0
 */
class UpdatePermissionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::table('permission')
            ->where('name', 'feedbackform')
            ->update(['name' => 'ticketfeedbackform', 'description' => 'ticketfeedbackform']);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::table('permission')
            ->where('name', 'ticketfeedbackform')
            ->update(['name' => 'feedbackform', 'description' => 'feedbackform']);
    }
}
