<?php
/**
 * File 2020_03_06_182658_update_setting_table.php
 *
 * @package    Database\Migrations\v3_0_0\Core
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 3.0.0
 */
namespace Database\Migrations\v3_0_0\Core;

use DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class UpdateSettingTable
 *
 * @package    Database\Migrations\v3_0_0\Core
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 3.0.0
 */
class UpdateSettingTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $module = DB::table('module')->where('slug', 'Selfservice')->first();
        if ($module === null) {
            $this->note("Self-service module not found. Cannot delete 'rating_show' setting.");

            return;
        }

        DB::table('setting')
            ->where('name', 'rating_show')
            ->where('module_id', $module->id)
            ->delete();
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        $module = DB::table('module')->where('slug', 'Selfservice')->first();
        if ($module === null) {
            $this->note("Self-service module not found. Cannot insert 'rating_show' setting.");

            return;
        }

        DB::table('setting')->insert([
            'module_id'  => 4,
            'name'       => 'rating_show',
            'value'      => 0,
            'created_at' => time(),
        ]);
    }
}
