<?php
/**
 * File 2019_11_20_164910_update_article_table.php
 *
 * @package    Database\Migrations\v3_0_0\Selfservice
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 3.0.0
 */
namespace Database\Migrations\v3_0_0\Selfservice;

use DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class UpdateArticleTable
 *
 * @package    Database\Migrations\v3_0_0\Selfservice
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      Class available since Release 3.0.0
 */
class UpdateArticleTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('article', function (Blueprint $table) {
            $table->longText('plain_text')->after('excerpt');
            $table->dropIndex('title');

            $table->dropColumn(['positive_rating', 'total_rating']);
        });

        DB::statement('ALTER TABLE `article` ADD FULLTEXT `article_title_ft_index` (`title`)');
        DB::statement('ALTER TABLE `article` ADD FULLTEXT `article_plain_text_ft_index` (`plain_text`)');

        foreach (DB::cursor("SELECT `id`, `text` FROM `article`") as $article) {
            DB::update("UPDATE `article` SET `plain_text` = ? WHERE `id` = ?", [
                html2text($article->text),
                $article->id
            ]);
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('article', function (Blueprint $table) {
            $table->dropColumn('plain_text');
        });

        DB::statement('ALTER TABLE `article` ADD FULLTEXT `title` (`title`, `text`)');
        DB::statement('ALTER TABLE `article` DROP INDEX `article_title_ft_index`');
        DB::statement('ALTER TABLE `article` DROP INDEX `article_plain_text_ft_index`');
    }
}
