<?php
/**
 * File 2019_11_20_171824_update_article_translation_table.php
 *
 * @package    Database\Migrations\v3_0_0\Selfservice
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 3.0.0
 */
namespace Database\Migrations\v3_0_0\Selfservice;

use DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class UpdateArticleTranslationTable
 *
 * @package    Database\Migrations\v3_0_0\Selfservice
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      Class available since Release 3.0.0
 */
class UpdateArticleTranslationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('article_translation', function (Blueprint $table) {
            $table->longText('plain_text')->after('excerpt');
            $table->dropIndex('title');
        });

        DB::statement('ALTER TABLE `article_translation` ADD FULLTEXT `article_translation_title_ft_index` (`title`)');
        DB::statement('ALTER TABLE `article_translation` ADD FULLTEXT `article_translation_plain_text_ft_index` (`plain_text`)');

        foreach (DB::cursor("SELECT `article_id`, `text` FROM `article_translation`") as $article) {
            DB::update("UPDATE `article_translation` SET `plain_text` = ? WHERE `article_id` = ?", [
                html2text($article->text),
                $article->article_id
            ]);
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('article_translation', function (Blueprint $table) {
            $table->dropColumn('plain_text');
        });

        DB::statement('ALTER TABLE `article_translation` ADD FULLTEXT `title` (`title`, `text`)');
        DB::statement('ALTER TABLE `article_translation` DROP INDEX `article_translation_title_ft_index`');
        DB::statement('ALTER TABLE `article_translation` DROP INDEX `article_translation_plain_text_ft_index`');
    }
}
