<?php
/**
 * File 2020_03_06_142047_create_article_feedback_form_table.php
 *
 * @package    Database\Migrations\v3_0_0\Selfservice
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 3.0.0
 */
namespace Database\Migrations\v3_0_0\Selfservice;

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class CreateArticleFeedbackFormTable
 *
 * @package    Database\Migrations\v3_0_0\Selfservice
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      Class available since Release 3.0.0
 */
class CreateArticleFeedbackFormTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('article_feedback_form', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->increments('id')->unsigned();

            $table->string('name', 45);
            $table->string('description')->nullable();
            $table->mediumInteger('order')->nullable();

            $table->tinyInteger('condition_group_type')->default(0);

            $table->integer('created_at');
            $table->integer('updated_at')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('article_feedback_form');
    }
}
