<?php
/**
 * File 2020_03_06_203655_update_article_rating_table.php
 *
 * @package    Database\Migrations\v3_0_0
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 3.0.0
 */
namespace Database\Migrations\v3_0_0;

use DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class UpdateArticleRatingTable
 *
 * @package    Database\Migrations\v3_0_0
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      Class available since Release 3.0.0
 */
class UpdateArticleRatingTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::rename("article_rating", "article_feedback_log");

        Schema::table('article_feedback_log', function (Blueprint $table) {
            $table->integer('form_id')->unsigned()->nullable()->after('article_id');
            $table->foreign('form_id')->references('id')->on('article_feedback_form')->onDelete('cascade');

            $table->renameColumn('score', 'rating');

            $table->tinyInteger('fields_answered')->default(0)->after('score');

            $table->index('updated_at');
        });

        // doctrine/dbal doesn't support changing tinyint columns...
        DB::statement('ALTER TABLE `article_feedback_log` CHANGE `rating` `rating` TINYINT(4) NULL DEFAULT NULL;');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::rename("article_feedback_log", "article_rating");

        Schema::table('article_rating', function (Blueprint $table) {
            $table->dropForeign(['form_id']);
            $table->dropColumn(['form_id', 'fields_answered']);

            $table->renameColumn('rating', 'score');

            $table->dropIndex(['updated_at']);
        });

        DB::statement('ALTER TABLE `article_rating` CHANGE `score` `score` TINYINT(4) NOT NULL;');
    }
}
