<?php
/**
 * File 2020_03_06_142145_create_article_feedback_form_field_translation_table.php
 *
 * @package    Database\Migrations\v3_0_0\Selfservice
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 3.0.0
 */
namespace Database\Migrations\v3_0_0\Selfservice;

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class CreateArticleFeedbackFormFieldTranslationTable
 *
 * @package    Database\Migrations\v3_0_0\Selfservice
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      Class available since Release 3.0.0
 */
class CreateArticleFeedbackFormFieldTranslationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('article_feedback_form_field_translation', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->integer('feedback_form_field_id')->unsigned();
            $table->foreign('feedback_form_field_id', 'article_feedback_form_field_id_fk')
                ->references('id')
                ->on('article_feedback_form_field')
                ->onDelete('cascade');

            $table->string('name');

            $table->string('locale', 5);
            $table->foreign('locale')->references('code')->on('language')->onDelete('cascade');

            $table->unique([ 'feedback_form_field_id', 'locale' ], 'article_feedback_form_field_id_locale_unique');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('article_feedback_form_field_translation');
    }
}
