<?php
/**
 * File 2020_03_06_142159_create_article_feedback_form_field_value_table.php
 *
 * @package    Database\Migrations\v3_0_0\Selfservice
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 3.0.0
 */
namespace Database\Migrations\v3_0_0\Selfservice;

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class CreateArticleFeedbackFormFieldValueTable
 *
 * @package    Database\Migrations\v3_0_0\Selfservice
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      Class available since Release 3.0.0
 */
class CreateArticleFeedbackFormFieldValueTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('article_feedback_form_field_value', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->increments('id')->unsigned();

            $table->integer('field_id')->unsigned();
            $table->foreign('field_id')->references('id')->on('article_feedback_form_field')->onDelete('cascade');

            $table->integer('feedback_id')->unsigned();
            $table->foreign('feedback_id')->references('id')->on('article_feedback_log')->onDelete('cascade');

            $table->text('value');

            $table->integer('created_at');
            $table->integer('updated_at')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('article_feedback_form_field_value');
    }
}
