<?php
/**
 * File 20192020_04_09_150000_update_article_type_table.php
 *
 * @package    Database\Migrations\v3_0_0\Selfservice
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 3.0.0
 */
namespace Database\Migrations\v3_0_0\Selfservice;

use DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class UpdateArticleTypeTable2
 *
 * @package    Database\Migrations\v3_0_0\Selfservice
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      Class available since Release 3.0.0
 */
class UpdateArticleTypeTable2 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::table('article_type')->update(['icon' => null]);

        Schema::table('article_type', function (Blueprint $table) {
            $table->string('icon')->change();
        });

        DB::table('article_type')->update(['icon' => 'fa-book']);
        DB::table('article_type')->where('name', 'Announcements')->update(['icon' => 'fa-newspaper']);
        DB::table('article_type')->where('name', 'Downloads')->update(['icon' => 'fa-download']);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('article_type', function (Blueprint $table) {
            $table->binary('icon')->change();
        });
    }
}
