<?php
/**
 * File 2019_11_08_1830000_update_operator_setting_table.php
 *
 * @package    Database\Migrations\v3_0_0\User
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 3.0.0
 */
namespace Database\Migrations\v3_0_0\User;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateOperatingSettingTable
 *
 * @package    Database\Migrations\v3_0_0\User
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 3.0.0
 */
class UpdateOperatingSettingTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('operator_setting', function (Blueprint $table) {
            $table->tinyInteger('template_mode')->default(0)->after('template');

            $table->dropColumn('ticket_grid_columns');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('operator_setting', function (Blueprint $table) {
            $table->dropColumn('template_mode');

            $table->string('ticket_grid_columns');
        });
    }
}
