<?php
/**
 * File 2020_07_27_172900_update_email_queue_table.php
 *
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
namespace Database\Migrations\v3_3_0\Core;

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class UpdateEmailQueueTable
 */
class UpdateEmailQueueTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('email_queue', function (Blueprint $table) {
            $table->string('guid')->nullable()->change();

            $table->text('headers')->nullable()->after('contents');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('email_queue', function (Blueprint $table) {
            $table->string('guid')->nullable(false)->change();

            $table->dropColumn('headers');
        });
    }
}
