<?php
/**
 * File 2020_08_24_145700_create_integration_setting_table.php
 *
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
namespace Database\Migrations\v3_3_0\Core;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class CreateIntegrationSettingTable
 */
class CreateIntegrationSettingTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Create table.
        Schema::create('integration_setting', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->increments('id')->unsigned();

            $table->integer('integration_id')->unsigned();
            $table->foreign('integration_id')->references('id')->on('integration')->onDelete('cascade');

            $table->integer('brand_id')->unsigned()->nullable();
            $table->foreign('brand_id')->references('id')->on('brand')->onDelete('cascade');

            $table->string('name', 255);
            $table->text('value');

            $table->integer('created_at');
            $table->integer('updated_at')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Drop table.
        Schema::drop('integration_setting');
    }
}
