<?php
/**
 * File 2020_09_14_102500_update_brand_table.php
 *
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
namespace Database\Migrations\v3_3_0\Core;

use App\Modules\Ticket\Models\DepartmentEmail;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class UpdateBrandTable
 */
class UpdateBrandTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('brand', function (Blueprint $table) {
            $table->string('smtp_auth_mech')
                ->nullable()
                ->after('smtp_requires_auth');

            $table->text('smtp_oauth')
                ->nullable()
                ->after('smtp_password');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('brand', function (Blueprint $table) {
            $table->dropColumn(['smtp_auth_mech', 'smtp_oauth']);
        });
    }
}
