<?php declare(strict_types=1);

/**
 * File 2020_10_26_140748_update_scheduled_task_table.php
 *
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
namespace Database\Migrations\v3_3_0\Core;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

/**
 * Class UpdateScheduledTaskTable
 */
class UpdateScheduledTaskTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('scheduled_task', function (Blueprint $table) {
            $table->integer('last_run')->default(0)->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('scheduled_task', function (Blueprint $table) {
            $table->integer('last_run')->default(null)->change();
        });
    }
}
